An invalid number of generic parameters was passed to an intrinsic function.

Erroneous code example:

```compile_fail,E0094
#![feature(intrinsics)]
#![allow(internal_features)]

#[rustc_intrinsic]
#[rustc_intrinsic_must_be_overridden]
fn size_of<T, U>() -> usize // error: intrinsic has wrong number
                            //        of type parameters
{
    loop {}
}
```

Please check that you provided the right number of type parameters
and verify with the function declaration in the Rust source code.
Example:

```
#![feature(intrinsics)]
#![allow(internal_features)]

#[rustc_intrinsic]
#[rustc_intrinsic_must_be_overridden]
fn size_of<T>() -> usize // ok!
{
    loop {}
}
```
