# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


### Firefox Home / New Tab strings for about:home / about:newtab.

newtab-page-title = ਨਵੀਂ ਟੈਬ
newtab-settings-button =
    .title = ਆਪਣੇ ਨਵੀਂ ਟੈਬ ਸਫ਼ੇ ਨੂੰ ਆਪਣੇ ਮੁਤਾਬਕ ਢਾਲੋ
newtab-customize-panel-icon-button =
    .title = ਇਸ ਸਫ਼ੇ ਨੂੰ ਕਸਟਮਾਈਜ਼ ਕਰੋ
newtab-customize-panel-icon-button-label = ਕਸਟਮਾਈਜ਼
newtab-personalize-settings-icon-label =
    .title = ਨਵੀਂ ਟੈਬ ਨੂੰ ਨਿੱਜੀ ਬਣਾਓ
    .aria-label = ਸੈਟਿੰਗਾਂ
newtab-settings-dialog-label =
    .aria-label = ਸੈਟਿੰਗਾਂ
newtab-personalize-icon-label =
    .title = ਨਵੀਂ ਟੈਬ ਨਿੱਜੀ ਬਣਾਓ
    .aria-label = ਨਵੀਂ ਟੈਬ ਨਿੱਜੀ ਬਣਾਓ
newtab-personalize-dialog-label =
    .aria-label = ਆਪਣਾ ਬਣਾਓ
newtab-logo-and-wordmark =
    .aria-label = { -brand-full-name }

## Search box component.

# "Search" is a verb/action
newtab-search-box-search-button =
    .title = ਖੋਜ
    .aria-label = ਖੋਜ
# Variables:
#   $engine (string) - The name of the user's default search engine
newtab-search-box-handoff-text = { $engine } ਨਾਲ ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
newtab-search-box-handoff-text-no-engine = ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
# Variables:
#   $engine (string) - The name of the user's default search engine
newtab-search-box-handoff-input =
    .placeholder = { $engine } ਨਾਲ ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
    .title = { $engine } ਨਾਲ ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
    .aria-label = { $engine } ਨਾਲ ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
newtab-search-box-handoff-input-no-engine =
    .placeholder = ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
    .title = ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
    .aria-label = ਖੋਜੋ ਜਾਂ ਸਿਰਨਾਵਾਂ ਦਿਓ
newtab-search-box-text = ਵੈੱਬ ‘ਤੇ ਖੋਜੋ
newtab-search-box-input =
    .placeholder = ਵੈੱਬ ‘ਤੇ ਖੋਜੋ
    .aria-label = ਵੈੱਬ ‘ਤੇ ਖੋਜੋ

## Top Sites - General form dialog.

newtab-topsites-add-search-engine-header = ਖੋਜ ਇੰਜਣ ਜੋੜੋ
newtab-topsites-add-shortcut-header = ਨਵਾਂ ਸ਼ਾਰਟਕੱਟ
newtab-topsites-edit-topsites-header = ਉਪਰਲੀ ਸਾਈਟ ਸੋਧੋ
newtab-topsites-edit-shortcut-header = ਸ਼ਾਰਟਕੱਟ ਨੂੰ ਸੋਧੋ
newtab-topsites-add-shortcut-label = ਸ਼ਾਰਟਕੱਟ ਨੂੰ ਜੋੜੋ
newtab-topsites-add-shortcut-title =
    .title = ਸ਼ਾਰਟਕੱਟ ਨੂੰ ਜੋੜੋ
    .aria-label = ਸ਼ਾਰਟਕੱਟ ਨੂੰ ਜੋੜੋ
newtab-topsites-title-label = ਸਿਰਲੇਖ
newtab-topsites-title-input =
    .placeholder = ਸਿਰਲੇਖ ਦਿਓ
newtab-topsites-url-label = URL
newtab-topsites-url-input =
    .placeholder = ਕੋਈ URL ਲਿਖੋ ਜਾਂ ਚੇਪੋ
newtab-topsites-url-validation = ਲੋੜੀਂਦਾ URL ਯੋਗ ਹੈ
newtab-topsites-image-url-label = URL ਕਸਟਮ ਚਿੱਤਰ
newtab-topsites-use-image-link = ਕਸਟਮ ਚਿੱਤਰ ਵਰਤੋ…
newtab-topsites-image-validation = ਚਿੱਤਰ ਲੋਡ ਕਰਨ ਤੋਂ ਅਸਫ਼ਲ ਰਿਹਾ। ਕਿਸੇ ਵੱਖਰੇ URL ਨਾਲ ਕੋਸ਼ਿਸ਼ ਕਰੋ।

## Top Sites - General form dialog buttons. These are verbs/actions.

newtab-topsites-cancel-button = ਰੱਦ ਕਰੋ
newtab-topsites-delete-history-button = ਅਤੀਤ ਵਿੱਚੋਂ ਹਟਾਓ
newtab-topsites-save-button = ਸੰਭਾਲੋ
newtab-topsites-preview-button = ਝਲਕ
newtab-topsites-add-button = ਜੋੜੋ

## Top Sites - Delete history confirmation dialog.

newtab-confirm-delete-history-p1 = ਕੀ ਤੁਸੀਂ 'ਤੇ ਆਪਣੇ ਅਤੀਤ ਵਿੱਚ ਇਸ ਸਫ਼ੇ ਦੀ ਹਰ ਮਿਸਾਲ ਨੂੰ ਹਟਾਉਣਾ ਮਿਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?
# "This action" refers to deleting a page from history.
newtab-confirm-delete-history-p2 = ਇਕ ਕਾਰਵਾਈ ਨੂੰ ਵਾਪਸ ਨਹੀਂ ਲਿਆ ਜਾ ਸਕਦਾ ਹੈ।

## Top Sites - Sponsored label

newtab-topsite-sponsored = ਸਪੌਂਸਰ ਕੀਤਾ

## Label used by screen readers for pinned top sites

# Variables:
#   $title (string) - The label or hostname of the site.
topsite-label-pinned =
    .aria-label = { $title } (ਟੰਗਿਆ)
    .title = { $title }

## Context Menu - Action Tooltips.

# General tooltip for context menus.
newtab-menu-section-tooltip =
    .title = ਮੇਨੂ ਖੋਲ੍ਹੋ
    .aria-label = ਮੇਨੂ ਖੋਲ੍ਹੋ
# Tooltip for dismiss button
newtab-dismiss-button-tooltip =
    .title = ਹਟਾਓ
    .aria-label = ਹਟਾਓ
# This tooltip is for the context menu of Pocket cards or Topsites
# Variables:
#   $title (string) - The label or hostname of the site. This is for screen readers when the context menu button is focused/active.
newtab-menu-content-tooltip =
    .title = ਮੇਨੂ ਖੋਲ੍ਹੋ
    .aria-label = { $title } ਦੇ ਲਈ ਪ੍ਰਸੰਗ ਮੀਨੂੰ ਖ੍ਹੋਲੋ
# Tooltip on an empty topsite box to open the New Top Site dialog.
newtab-menu-topsites-placeholder-tooltip =
    .title = ਇਹ ਸਾਈਟ ਨੂੰ ਸੋਧੋ
    .aria-label = ਇਹ ਸਾਈਟ ਨੂੰ ਸੋਧੋ

## Context Menu: These strings are displayed in a context menu and are meant as a call to action for a given page.

newtab-menu-edit-topsites = ਸੋਧੋ
newtab-menu-open-new-window = ਨਵੀਂ ਵਿੰਡੋ ਵਿੱਚ ਖੋਲ੍ਹੋ
newtab-menu-open-new-private-window = ਨਵੀਂ ਪ੍ਰਾਈਵੇਟ ਵਿੰਡੋ ਵਿੱਚ ਖੋਲ੍ਹੋ
newtab-menu-dismiss = ਰੱਦ ਕਰੋ
newtab-menu-pin = ਟੰਗੋ
newtab-menu-unpin = ਲਾਹੋ
newtab-menu-delete-history = ਅਤੀਤ ਵਿੱਚੋਂ ਹਟਾਓ
newtab-menu-save-to-pocket = { -pocket-brand-name } ਵਿੱਚ ਸੰਭਾਲੋ
newtab-menu-delete-pocket = { -pocket-brand-name } ਤੋਂ ਹਟਾਓ
newtab-menu-archive-pocket = { -pocket-brand-name } ਵਿੱਚ ਪੁਰਾਲੇਖਬੱਧ ਕਰੋ
newtab-menu-show-privacy-info = ਸਾਡੇ ਸਪਾਂਸਰ ਅਤੇ ਤੁਹਾਡੀ ਪਰਦੇਦਾਰੀ
newtab-menu-about-fakespot = { -fakespot-brand-name } ਬਾਰੇ
# Report is a verb (i.e. report issue with the content).
newtab-menu-report = ਰਿਪੋਰਟ
# Context menu option to personalize New Tab recommended stories by blocking a section of stories,
# e.g. "Sports". "Block" is a verb here.
newtab-menu-section-block = ਪਾਬੰਦੀ
# "Follow", "unfollow", and "following" are social media terms that refer to subscribing to or unsubscribing from a section of stories.
# e.g. Following the travel section of stories.
newtab-menu-section-unfollow = ਵਿਸ਼ੇ ਨੂੰ ਅਣ-ਫ਼ਾਲੋ ਕਰੋ

## Context menu options for sponsored stories and new ad formats on New Tab.

newtab-menu-manage-sponsored-content = ਸਪੌਂਸਰ ਕੀਤੀ ਸਮੱਗਰੀ ਦਾ ਇੰਤਜ਼ਾਮ
newtab-menu-our-sponsors-and-your-privacy = ਸਾਡੇ ਸਪੌਂਸਰ ਅਤੇ ਤੁਹਾਡੀ ਪਰਦੇਦਾਰੀ
newtab-menu-report-this-ad = ਇਸ ਇਸ਼ਤਿਹਾਰ ਬਾਰੇ ਰਿਪੋਰਟ ਕਰੋ

## Message displayed in a modal window to explain privacy and provide context for sponsored content.

newtab-privacy-modal-button-done = ਮੁਕੰਮਲ
newtab-privacy-modal-button-manage = ਸਪਾਂਸਰ ਕੀਤੀ ਸਮੱਗਰੀ ਦੇ ਇੰਤਜ਼ਾਮ ਲਈ ਸੈਟਿੰਗਾਂ
newtab-privacy-modal-header = ਤੁਹਾਡੀ ਪਰਦੇਦਾਰੀ ਮਹੱਤਵ ਰੱਖਦੀ ਹੈ।
newtab-privacy-modal-paragraph-2 =
    ਮਨਮੋਹਣੀਆਂ ਕਹਾਣੀਆਂ ਪਰੋਸਣ ਤੋਂ ਇਲਾਵਾ, ਅਸੀਂ ਤੁਹਾਨੂੰ ਢੁਕਵੇਂ,
    ਚੋਣਵੇਂ ਪੇਸ਼ਕਾਰਾਂ ਤੋਂ ਬਹੁਤ ਜ਼ਿਆਦਾ ਜਾਂਚੀ ਗਈ ਸਮੱਗਰੀ ਵਿਖਾਵਾਂਗੇ। ਭਰੋਸਾ ਕਰੋ, <strong>ਤੁਹਾਡਾ ਬਰਾਊਜ਼ਿੰਗ ਡਾਟਾ ਤੁਹਾਡੇ { -brand-product-name } — ਦੀ ਨਿੱਜੀ ਕਾਪੀ ਤੋਂ ਕਦੇ ਬਾਹਰ ਨਹੀਂ ਜਾਂਦਾ</strong> — ਅਸੀਂ ਇਸਨੂੰ ਨਹੀਂ ਵੇਖਦੇ, ਅਤੇ ਸਾਡੇ
    ਸਪੌਂਸਰ ਵੀ ਕਦੇ ਨਹੀਂ।
newtab-privacy-modal-link = ਸਿੱਖੋ ਕਿ ਨਵੀਂ ਟੈਬ ਉੱਤੇ ਪਰਦੇਦਾਰੀ ਕਿਵੇਂ ਕੰਮ ਕਰਦੀ ਹੈ।

##

# Bookmark is a noun in this case, "Remove bookmark".
newtab-menu-remove-bookmark = ਬੁੱਕਮਾਰਕ ਨੂੰ ਹਟਾਓ
# Bookmark is a verb here.
newtab-menu-bookmark = ਬੁੱਕਮਾਰਕ

## Context Menu - Downloaded Menu. "Download" in these cases is not a verb,
## it is a noun. As in, "Copy the link that belongs to this downloaded item".

newtab-menu-copy-download-link = ਡਾਊਨਲੋਡ ਲਿੰਕ ਨੂੰ  ਕਾਪੀ ਕਰੋ
newtab-menu-go-to-download-page = ਡਾਊਨਲੋਡ ਪੰਨੇ 'ਤੇ ਜਾਓ
newtab-menu-remove-download = ਅਤੀਤ ਤੋਂ ਹਟਾਓ

## Context Menu - Download Menu: These are platform specific strings found in the context menu of an item that has
## been downloaded. The intention behind "this action" is that it will show where the downloaded file exists on the file
## system for each operating system.

newtab-menu-show-file =
    { PLATFORM() ->
        [macos] Finder ਵਿੱਚ ਵੇਖੋ
       *[other] ਰੱਖਣ ਵਾਲਾ ਫੋਲਡਰ ਖੋਲ੍ਹੋ
    }
newtab-menu-open-file = ਫਾਈਲ ਖੋਲ੍ਹੋ

## Card Labels: These labels are associated to pages to give
## context on how the element is related to the user, e.g. type indicates that
## the page is bookmarked, or is currently open on another device.

newtab-label-visited = ਖੋਲ੍ਹੀਆਂ
newtab-label-bookmarked = ਬੁੱਕਮਾਰਕ ਕੀਤੀਆਂ
newtab-label-removed-bookmark = ਬੁੱਕਮਾਰਕ ਨੂੰ ਹਟਾਇਆ
newtab-label-recommended = ਰੁਝਾਨ
newtab-label-saved = { -pocket-brand-name } ਵਿੱਚ ਸੰਭਾਲਿਆ
newtab-label-download = ਡਾਊਨਲੋਡ ਕੀਤੇ ਹੋਏ
# This string is used in the story cards to indicate sponsored content
# Variables:
#   $sponsorOrSource (string) - The name of a company or their domain
newtab-label-sponsored = { $sponsorOrSource } · ਸਪਾਂਸਰ ਕੀਤਾ
# This string is used at the bottom of story cards to indicate sponsored content
# Variables:
#   $sponsor (string) - The name of a sponsor
newtab-label-sponsored-by = { $sponsor } ਵਲੋਂ ਸਪਾਂਸਰ ਕੀਤਾ
# This string is used under the image of story cards to indicate source and time to read
# Variables:
#   $source (string) - The name of a company or their domain
#   $timeToRead (number) - The estimated number of minutes to read this story
newtab-label-source-read-time = { $source } · { $timeToRead } ਮਿੰਟ
# This string is used under fixed size ads to indicate sponsored content
newtab-label-sponsored-fixed = ਸਪੌਂਸਰ ਕੀਤੇ

## Section Menu: These strings are displayed in the section context menu and are
## meant as a call to action for the given section.

newtab-section-menu-remove-section = ਸੈਕਸ਼ਨ ਹਟਾਓ
newtab-section-menu-collapse-section = ਸੈਕਸ਼ਨ ਨੂੰ ਸਮੇਟੋ
newtab-section-menu-expand-section = ਸੈਕਸ਼ਨ ਦੀ ਫੈਲਾਓ
newtab-section-menu-manage-section = ਸੈਕਸ਼ਨ ਦਾ ਬੰਦੋਬਸਤ
newtab-section-menu-manage-webext = ਇਕਸਟੈਨਸ਼ਨ ਦਾ ਇੰਤਜ਼ਾਮ
newtab-section-menu-add-topsite = ਚੋਟੀ ਦੀਆਂ ਸਾਈਟਾਂ ਜੋੜੋ
newtab-section-menu-add-search-engine = ਖੋਜ ਇੰਜਣ ਜੋੜੋ
newtab-section-menu-move-up = ਉੱਤੇ ਭੇਜੋ
newtab-section-menu-move-down = ਹੇਠਾਂ ਭੇਜੋ
newtab-section-menu-privacy-notice = ਪਰਦੇਦਾਰੀ ਸੂਚਨਾ

## Section aria-labels

newtab-section-collapse-section-label =
    .aria-label = ਭਾਗ ਨੂੰ ਸਮੇਟੋ
newtab-section-expand-section-label =
    .aria-label = ਭਾਗ ਫੈਲਾਓ

## Section Headers.

newtab-section-header-topsites = ਸਿਖਰਲੀਆਂ ਸਾਈਟਾਂ
newtab-section-header-recent-activity = ਤਾਜ਼ਾ ਸਰਗਰਮੀ
# Variables:
#   $provider (string) - Name of the corresponding content provider.
newtab-section-header-pocket = { $provider } ਵਲੋਂ ਸਿਫਾਰਸ਼ੀ
newtab-section-header-stories = ਸੋਚਣ ਲਈ ਮਜ਼ਬੂਰ ਕਰਨ ਵਾਲੇ ਲੇਖ
# "picks" refers to recommended articles
newtab-section-header-todays-picks = ਤੁਹਾਡੇ ਲਈ ਅੱਜ ਦੀਆਂ ਚੋਣਾਂ

## Empty Section States: These show when there are no more items in a section. Ex. When there are no more Pocket story recommendations, in the space where there would have been stories, this is shown instead.

newtab-empty-section-highlights = ਬਰਾਊਜ਼ ਕਰਨਾ ਸ਼ੁਰੂ ਕਰੋ ਅਤੇ ਅਸੀਂ ਕੁਝ ਵਧੀਆ ਲੇਖ, ਵਿਡੀਓ ਤੇ ਤੁਹਾਡੇ ਵਲੋਂ ਖੋਲ੍ਹੋ ਗਏ ਜਾਂ ਬੁੱਕਮਾਰਕ ਕੀਤੇ ਹੋਰ ਸਫ਼ੇ ਇੱਥੇ ਦਿਖਾਵਾਂਗੇ।
# Ex. When there are no more Pocket story recommendations, in the space where there would have been stories, this is shown instead.
# Variables:
#   $provider (string) - Name of the content provider for this section, e.g "Pocket".
newtab-empty-section-topstories = ਤੁਸੀਂ ਪੂਰਾ ਕਰ ਚੁੱਕੇ ਹੋ। { $provider } ਵਲੋਂ ਹੋਰ ਕਹਾਣੀਆਂ ਲਈ ਬਾਅਦ ਵਿੱਚ ਵਾਪਸ ਚੈਕ ਕਰੀਓ। ਉਡੀਕ ਨਹੀਂ ਕਰ ਸਕਦੇ? ਤਾਂ ਫੇਰ ਵੈੱਬ ਉਤੋਂ ਹੋਰ ਵਧੀਆ ਕਹਾਣੀਆਂ ਵਾਸਤੇ ਹਰਮਨਪਿਆਰੇ ਵਿਸ਼ੇ ਨੂੰ ਚੁਣੋ।
# Ex. When there are no more story recommendations, in the space where there would have been stories, this is shown instead.
newtab-empty-section-topstories-generic = ਤੁਸੀਂ ਪੂਰਾ ਕਰ ਚੁੱਕੇ ਹੋ। ਹੋਰ ਕਹਾਣੀਆਂ ਲਈ ਬਾਅਦ ਵਿੱਚ ਵਾਪਸ ਚੈਕ ਕਰੀਓ। ਉਡੀਕ ਨਹੀਂ ਕਰ ਸਕਦੇ? ਤਾਂ ਫੇਰ ਵੈੱਬ ਉਤੋਂ ਹੋਰ ਵਧੀਆ ਕਹਾਣੀਆਂ ਵਾਸਤੇ ਹਰਮਨਪਿਆਰੇ ਵਿਸ਼ੇ ਨੂੰ ਚੁਣੋ।

## Empty Section (Content Discovery Experience). These show when there are no more stories or when some stories fail to load.

newtab-discovery-empty-section-topstories-header = ਤੁਸੀਂ ਅਟਕ ਗਏ!
newtab-discovery-empty-section-topstories-content = ਹੋਰ ਕਹਾਣੀਆਂ ਲਈ ਬਾਅਦ ‘ਚ ਜਾਂਚ ਕਰੋ।
newtab-discovery-empty-section-topstories-try-again-button = ਮੁੜ-ਕੋਸ਼ਿਸ਼ ਕਰੋ
newtab-discovery-empty-section-topstories-loading = ਲੋਡ ਕੀਤਾ ਜਾ ਰਿਹਾ ਹੈ…
# Displays when a layout in a section took too long to fetch articles.
newtab-discovery-empty-section-topstories-timed-out = ਓਹ ਹੋ! ਅਸੀਂ ਇਹ ਭਾਗ ਲੋਡ ਕਰ ਹੀ ਲਿਆ ਸੀ, ਫੇਰ ਵੀ ਹੋ ਨੀ ਸਕਿਆ।

## Pocket Content Section.

# This is shown at the bottom of the trending stories section and precedes a list of links to popular topics.
newtab-pocket-read-more = ਹਰਮਨਪਿਆਰੇ ਵਿਸ਼ੇ:
newtab-pocket-new-topics-title = ਹੋਰ ਲੇਖ ਚਾਹੁੰਦੇ ਹੋ? { -pocket-brand-name } ਵਲੋਂ ਇਹ ਹਰਮਨਪਿਆਰੇ ਵਿਸ਼ੇ ਵੇਖੋ
newtab-pocket-more-recommendations = ਹੋਰ ਸਿਫਾਰਸ਼ਾਂ
newtab-pocket-learn-more = ਹੋਰ ਜਾਣੋ
newtab-pocket-cta-button = { -pocket-brand-name } ਲਵੋ
newtab-pocket-cta-text = { -pocket-brand-name } ਵਿਚ ਆਪਣੀਆਂ ਕਹਾਣੀਆਂ ਨੂੰ ਸੁਰੱਖਿਅਤ ਕਰੋ, ਅਤੇ ਆਪਣੇ ਮਨ ਨੂੰ ਦਿਲਚਸਪ ਪੜ੍ਹ ਕੇ ਮਜਬੂਰ ਕਰੋ।
newtab-pocket-pocket-firefox-family = { -pocket-brand-name } { -brand-product-name } ਗਰੁੱਪ ਦਾ ਭਾਗ ਹੈ
newtab-pocket-save = ਸੰਭਾਲੋ
newtab-pocket-saved = ਸੰਭਾਲਿਆ

## Thumbs up and down buttons that shows over a newtab stories card thumbnail on hover.

# Clicking the thumbs up button for this story will result in more stories like this one being recommended
newtab-pocket-thumbs-up-tooltip =
    .title = ਇਸ ਵਰਗੇ ਹੋਰ
# Clicking the thumbs down button for this story informs us that the user does not feel like the story is interesting for them
newtab-pocket-thumbs-down-tooltip =
    .title = ਮੇਰੇ ਲਈ ਨਹੀਂ
# Used to show the user a message upon clicking the thumbs up or down buttons
newtab-toast-thumbs-up-or-down2 =
    .message = ਧੰਨਵਾਦ! ਤੁਹਾਡਾ ਸੁਝਾਅ ਸਾਡੀ ਫੀਡ ਸੁਧਾਰਨ ਲਈ ਮਦਦਗਾਰ ਹੋਵੇਗਾ।
newtab-toast-dismiss-button =
    .title = ਖ਼ਾਰਜ ਕਰੋ
    .aria-label = ਖ਼ਾਰਜ ਕਰੋ

## Pocket content onboarding experience dialog and modal for new users seeing the Pocket section for the first time, shown as the first item in the Pocket section.

newtab-pocket-onboarding-discover = ਵੈੱਬ ਤੋਂ ਸਭ ਤੋਂ ਵਧੀਆ ਖੋਜੋ
newtab-pocket-onboarding-cta = { -pocket-brand-name } ਤੁਹਾਡੇ { -brand-product-name } ਬਰਾਊਜ਼ਰ ਲਈ ਵੱਧ ਜਾਣਕਾਰੀ ਭਰਪੂਰ, ਪ੍ਰੇਰਨਾਦਾਇਕ ਅਤੇ ਭਰੋਸੇਯੋਗ ਸਮੱਗਰੀ ਦੇਣ ਵਾਸਤੇ ਬਹੁਤ ਸਾਰੇ ਪ੍ਰਕਾਸ਼ਨ ਦੀ ਛਾਣਬੀਣ ਕਰਦਾ ਹੈ।

## Error Fallback Content.
## This message and suggested action link are shown in each section of UI that fails to render.

newtab-error-fallback-info = ਓਹ ਹੋ, ਇਸ ਸਮੱਗਰੀ ਨੂੰ ਲੋਡ ਕਰਨ ਵਿੱਚ ਕੁਝ ਗਲਤ ਹੋ ਗਿਆ।
newtab-error-fallback-refresh-link = ਮੁੜ ਕੋਸ਼ਿਸ਼ ਲਈ ਸਫ਼ੇ ਨੂੰ ਤਾਜ਼ਾ ਕਰੋ।

## Customization Menu

newtab-custom-shortcuts-title = ਸ਼ਾਰਟਕੱਟ
newtab-custom-shortcuts-subtitle = ਸਾਈਟਾਂ ਤੁਸੀਂ ਸੰਭਾਲੀਆਂ ਜਾਂ ਖੋਲ੍ਹੀਆਂ
newtab-custom-shortcuts-toggle =
    .label = ਸ਼ਾਰਟਕੱਟ
    .description = ਸਾਈਟਾਂ ਤੁਸੀਂ ਸੰਭਾਲੀਆਂ ਜਾਂ ਖੋਲ੍ਹੀਆਂ
# Variables
#   $num (number) - Number of rows to display
newtab-custom-row-selector =
    { $num ->
        [one] { $num } ਕਤਾਰ
       *[other] { $num } ਕਤਾਰ
    }
newtab-custom-sponsored-sites = ਸਪਾਂਸਰ ਕੀਤੇ ਸ਼ਾਰਟਕੱਟ
newtab-custom-pocket-title = { -pocket-brand-name } ਵਲੋਂ ਸਿਫਾਰਸ਼ ਕੀਤੇ
newtab-custom-pocket-subtitle = { -brand-product-name } ਦੇ ਹਿੱਸੇ ਵਜੋਂ { -pocket-brand-name } ਵਲੋਂ ਖਾਸ ਇਕੱਤਰ ਕੀਤੀ ਸਮੱਗਰੀ
newtab-custom-stories-toggle =
    .label = ਸਿਫ਼ਾਰਸ਼ੀ ਕਹਾਣੀਆਂ
    .description = { -brand-product-name } ਸਮੂਹ ਵਲੋਂ ਤਿਆਰੀ ਕੀਤੀ ਖਾਸ ਸਮੱਗਰੀ
newtab-custom-stories-personalized-toggle =
    .label = ਲੇਖ
newtab-custom-stories-personalized-checkbox-label = ਤੁਹਾਡੀ ਸਰਗਰਮੀ ਦੇ ਮੁਤਾਬਕ ਨਿੱਜੀ ਬਣਾਏ ਗਏ ਲੇਖ
newtab-custom-pocket-sponsored = ਸਪਾਂਸਰ ਕੀਤੀਆਂ ਕਹਾਣੀਆਂ
newtab-custom-pocket-show-recent-saves = ਸੱਜਰੇ ਸੰਭਾਲੇ ਵੇਖੋ
newtab-custom-recent-title = ਤਾਜ਼ਾ ਸਰਗਰਮੀ
newtab-custom-recent-subtitle = ਤਾਜ਼ਾ ਸਾਈਟਾਂ ਤੇ ਸਮੱਗਰੀ ਦੀ ਚੋਣ
newtab-custom-weather-toggle =
    .label = ਮੌਸਮ
    .description = ਅੱਜ ਦੇ ਮੌਸਮ ਬਾਰੇ ਝਾਤ
newtab-custom-trending-search-toggle =
    .label = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ
    .description = ਹਰਮਨਪਿਆਰੇ ਅਤੇ ਅਕਸਰ ਖੋਜੇ ਗਏ ਵਿਸ਼ੇ
newtab-custom-widget-weather-toggle =
    .label = ਮੌਸਮ
newtab-custom-widget-trending-search-toggle =
    .label = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ
newtab-custom-widget-lists-toggle =
    .label = ਸੂਚੀਆਂ
newtab-custom-widget-timer-toggle =
    .label = ਟਾਈਮਰ
newtab-custom-widget-section-title = ਵਿਜੈੱਟ
# Tooltip for close button
newtab-custom-close-menu-button =
    .title = ਬੰਦ ਕਰੋ
    .aria-label = ਮੇਨ ਨੂੰ ਬੰਦ ਕਰੋ
newtab-custom-close-button = ਬੰਦ ਕਰੋ
newtab-custom-settings = ਹੋਰ ਸੈਟਿੰਗਾਂ ਦਾ ਇੰਤਜ਼ਾਮ ਕਰੋ

## New Tab Wallpapers

newtab-wallpaper-title = ਵਾਲਪੇਪਰ
newtab-wallpaper-reset = ਮੂਲ ਲਈ ਮੁੜ-ਸੈੱਟ ਕਰੋ
newtab-wallpaper-upload-image = ਚਿੱਤਰ ਨੂੰ ਅੱਪਲੋਡ ਕਰੋ
newtab-wallpaper-custom-color = ਰੰਗ ਨੂੰ ਚੁਣੋ
# Variables
#   $file_size (number) - The number of the maximum image file size (in MB) that may be uploaded
newtab-wallpaper-error-max-file-size = ਚਿੱਤਰ ਫ਼ਾਇਲ ਦਾ ਆਕਾਰ { $file_size } MB ਤੋਂ ਵੱਧ ਗਿਆ ਹੈ। ਕਿਰਪਾ ਕਰਕੇ ਛੋਟੇ ਆਕਾਰ ਦੀ ਫਾਇਲ ਅੱਪਲੋਡ ਕਰਨ ਦੀ ਕੋਸ਼ਿਸ਼ ਕਰੋ।
newtab-wallpaper-error-upload-file-type = ਅਸੀਂ ਤੁਹਾਡੀ ਫ਼ਾਇਲ ਨੂੰ ਅੱਪਲੋਡ ਨਹੀਂ ਕਰ ਸਕੇ ਹਾਂ। ਚਿੱਤਰ  ਫ਼ਾਇਲ ਨਾਲ ਫੇਰ ਕੋਸ਼ਿਸ਼ ਕਰਕੇ ਵੇਖੋ।
newtab-wallpaper-error-file-type = ਅਸੀਂ ਤੁਹਾਡੀ ਫ਼ਾਇਲ ਨੂੰ ਅੱਪਲੋਡ ਨਹੀਂ ਕਰ ਸਕੇ ਹਾਂ। ਵੱਖਰੀ ਫ਼ਾਇਲ ਕਿਸਮ ਨਾਲ ਫੇਰ ਕੋਸ਼ਿਸ਼ ਕਰਕੇ ਵੇਖੋ।
newtab-wallpaper-light-red-panda = ਲਾਲ ਪਾਂਡਾ
newtab-wallpaper-light-mountain = ਚਿੱਟਾ ਪਹਾੜ
newtab-wallpaper-light-sky = ਜਾਮਨੀ ਅਤੇ ਗੁਲਾਬੀ ਬੱਦਲਾਂ ਨਾਲ ਅਸਮਾਨ
newtab-wallpaper-light-color = ਨੀਲਾ, ਗੁਲਾਬੀ ਅਤੇ ਪੀਲੀਆਂ ਸ਼ਕਲਾਂ
newtab-wallpaper-light-landscape = ਨੀਲੀ ਧੁੰਦ ਵਾਲਾ ਪਹਾੜੀ ਦ੍ਰਿਸ਼
newtab-wallpaper-light-beach = ਪਾਮ ਦੇ ਰੁੱਖ ਨਾਲ ਬੀਚ
newtab-wallpaper-dark-aurora = ਅਰੋਰਾ ਬੋਰਿਲਿਸ
newtab-wallpaper-dark-color = ਲਾਲ ਅਤੇ ਨੀਲੀਆਂ ਸ਼ਕਲਾਂ
newtab-wallpaper-dark-panda = ਜੰਗਲ ਵਿੱਚ ਲੁਕਿਆ ਫਿਰਦਾ ਲਾਲ ਪਾਂਡਾ
newtab-wallpaper-dark-sky = ਨੀਲੇ ਅੰਬਰ ਨਾਲ ਸ਼ਹਿਰ ਦਾ ਦ੍ਰਿਸ਼
newtab-wallpaper-dark-mountain = ਲੈਂਡਸਕੇਪ ਪਹਾੜ
newtab-wallpaper-dark-city = ਜਾਮਨੀ ਸ਼ਹਿਰੀ ਦ੍ਰਿਸ਼
newtab-wallpaper-dark-fox-anniversary = ਜੰਗਲ ਨੇੜਲੇ ਰਾਹ ਉੱਤੇ ਲੂੰਬੜੀ
newtab-wallpaper-light-fox-anniversary = ਧੁੰਦ ਵਿੱਚ ਲੁਕੇ ਪਹਾੜ ਦੇ ਕੋਲ ਘਾਹ ਦੇ ਖੇਤ ਵਿੱਚ ਲੂੰਬੜੀ

## Solid Colors

newtab-wallpaper-category-title-colors = ਇਕਸਾਰ ਰੰਗ
newtab-wallpaper-blue = ਨੀਲਾ
newtab-wallpaper-light-blue = ਹਲਕਾ ਨੀਲਾ
newtab-wallpaper-light-purple = ਹਲਕਾ ਜਾਮਨੀ
newtab-wallpaper-light-green = ਹਲਕਾ ਹਰਾ
newtab-wallpaper-green = ਹਰਾ
newtab-wallpaper-beige = ਬਿਸਕੁਟੀ
newtab-wallpaper-yellow = ਪੀਲਾ
newtab-wallpaper-orange = ਸੰਤਰੀ
newtab-wallpaper-pink = ਗੁਲਾਬੀ
newtab-wallpaper-light-pink = ਹਲਕਾ ਗੁਲਾਬੀ
newtab-wallpaper-red = ਲਾਲ
newtab-wallpaper-dark-blue = ਗੂੜ੍ਹਾ ਨੀਲਾ
newtab-wallpaper-dark-purple = ਗੂੜ੍ਹਾ ਜਾਮਨੀ
newtab-wallpaper-dark-green = ਗੂੜ੍ਹਾ ਹਰਾ
newtab-wallpaper-brown = ਭੂਰਾ

## Abstract

newtab-wallpaper-category-title-abstract = ਸੰਖੇਪ
newtab-wallpaper-abstract-green = ਹਰੀਆਂ ਸ਼ਕਲਾਂ
newtab-wallpaper-abstract-blue = ਨੀਲੀਆਂ ਸ਼ਕਲਾਂ
newtab-wallpaper-abstract-purple = ਜਾਮਨੀ ਸ਼ਕਲਾਂ
newtab-wallpaper-abstract-orange = ਸੰਤਰੀ ਸ਼ਕਲਾਂ
newtab-wallpaper-gradient-orange = ਗਰੇਡੀਐਂਟ ਸੰਤਰੀ ਤੇ ਗੁਲਾਬੀ
newtab-wallpaper-abstract-blue-purple = ਨੀਲੀਆਂ ਤੇ ਜਾਮਨੀ ਸ਼ਕਲਾਂ
newtab-wallpaper-abstract-white-curves = ਸੇਡ ਵਾਲੇ ਵਲਾਂ ਨਾਲ ਚਿੱਟਾ
newtab-wallpaper-abstract-purple-green = ਜਾਮਨੀ ਅਤੇ ਹਰਾ ਫਿੱਕਾ ਗਰੇਡੀਐਂਟ
newtab-wallpaper-abstract-blue-purple-waves = ਨੀਲੀਆਂ ਤੇ ਜਾਮਨੀ ਲਹਿਰਦਾਰ ਸ਼ਕਲਾਂ
newtab-wallpaper-abstract-black-waves = ਕਾਲੀਆਂ ਲਹਿਰਦਾਰ ਸ਼ਕਲਾਂ

## Firefox

newtab-wallpaper-category-title-photographs = ਫ਼ੋਟੋਗਰਾਫ਼
newtab-wallpaper-beach-at-sunrise = ਬੀਚ ਉੱਤੇ ਚੜ੍ਹਦਾ ਸੂਰਜ
newtab-wallpaper-beach-at-sunset = ਬੀਚ ਉੱਤੇ ਡੁੱਬਦਾ ਸੂਰਜ
newtab-wallpaper-storm-sky = ਤੂਫ਼ਾਨੀ ਅੰਬਰ
newtab-wallpaper-sky-with-pink-clouds = ਗੁਲਾਬੀ ਬੱਦਲਾਂ ਨਾਲ ਅੰਬਰ
newtab-wallpaper-red-panda-yawns-in-a-tree = ਲਾਲ ਪਾਂਡਾ ਰੁੱਖ ਹੇਠ ਉਬਾਸੀਆਂ ਲੈਂਦਾ ਹੋਇਆ
newtab-wallpaper-white-mountains = ਚਿੱਟੇ ਪਹਾੜ
newtab-wallpaper-hot-air-balloons = ਦਿਨ ਵੇਲੇ ਗਰਮ ਹਵਾ ਦੇ ਗੁਬਾਰਿਆਂ ਦੇ ਵੱਖ-ਵੱਖ ਰੰਗ
newtab-wallpaper-starry-canyon = ਨੀਲੀ ਤਾਰਿਆਂ ਵਾਲੀ ਰਾਤ
newtab-wallpaper-suspension-bridge = ਦਿਨ ਵੇਲੇ ਸਲੇਟੀ ਪੂਰੇ ਲਟਕਦੇ ਪੁਲ ਦੀ ਫੋਟੋਗਰਾਫ਼ੀ
newtab-wallpaper-sand-dunes = ਚਿੱਟੇ ਰੇਤ ਦੇ ਟਿੱਬੇ
newtab-wallpaper-palm-trees = ਸਵੱਖਤੇ ਸੋਨੇ ਰੰਗੇ ਚਾਨਣ ਵਿੱਚ ਨਾਰੀਅਲ ਦੇ ਰੁੱਖਾਂ ਦੀ ਛਾਂ
newtab-wallpaper-blue-flowers = ਖਿੜੇ ਹੋਏ ਨੀਲੇ-ਪੰਖੜੀਆਂ ਵਾਲੇ ਫੁੱਲਾਂ ਦੀ ਨੇੜਿਓ ਫੋਟੋਗਰਾਫ਼ੀ
# Variables
#   $author_string (String) - The name of the creator of the photo.
#   $webpage_string (String) - The name of the webpage where the photo is located.
newtab-wallpaper-attribution = <a data-l10n-name="name-link">{ $author_string }</a> ਵਲੋਂ <a data-l10n-name="webpage-link">{ $webpage_string }</a> ਉੱਤੇ ਪਾਈ ਫ਼ੋਟੋ
newtab-wallpaper-feature-highlight-header = ਰੰਗ ਪਾ ਕੇ ਵੇਖੋ
newtab-wallpaper-feature-highlight-content = ਆਪਣੀ ਨਵੀਂ ਟੈਬ ਨੂੰ ਵਾਲਪੇਪਰ ਨਾਲ ਤਾਜ਼ਾ ਦਿੱਖ ਦਿਓ।
newtab-wallpaper-feature-highlight-button = ਸਮਝੇ
# Tooltip for dismiss button
feature-highlight-dismiss-button =
    .title = ਖ਼ਾਰਜ ਕਰੋ
    .aria-label = ਪੌਪ-ਅੱਪ ਨੂੰ ਬੰਦ ਕਰੋ
feature-highlight-wallpaper =
    .title = { -newtab-wallpaper-feature-highlight-header }
    .aria-label = { -newtab-wallpaper-feature-highlight-content }

## Firefox

newtab-wallpaper-category-title-firefox = { -brand-product-name }

## Celestial

# “Celestial” referring to astronomy; positioned in or relating to the sky,
# or outer space as observed in astronomy.
# Not to be confused with religious definition of the word.
newtab-wallpaper-category-title-celestial = ਅੰਬਰ
newtab-wallpaper-celestial-lunar-eclipse = ਚੰਦ ਗ੍ਰਹਿਣ
newtab-wallpaper-celestial-earth-night = ਧਰਤੀ ਦੇ ਹੇਠਲੇ ਪੰਧ ਤੋਂ ਰਾਤ ਦੀ ਫ਼ੋਟੋ
newtab-wallpaper-celestial-starry-sky = ਤਾਰਿਆਂ ਵਾਲਾ ਅਸਮਾਨ
newtab-wallpaper-celestial-eclipse-time-lapse = ਸਮੇਂ ਦੇ ਪਰਿਪੇਖ ਵਿੱਚ ਚੰਦ ਗ੍ਰਹਿਣ
newtab-wallpaper-celestial-black-hole = ਬਲੈਕ ਹੋਲ ਗੈਲਕਸੀ ਦਾ ਚਿੱਤਰ
newtab-wallpaper-celestial-river = ਦਰਿਆ ਦਾ ਉਪ-ਗ੍ਰਹਿ ਰਾਹੀਂ ਤਸਵੀਰ

## New Tab Weather

# Variables:
#   $provider (string) - Service provider for weather data
newtab-weather-see-forecast =
    .title = { $provider } ਵਿੱਚ ਭਵਿੱਖਬਾਣੀ ਵੇਖੋ
# Variables:
#   $provider (string) - Service provider for weather data
newtab-weather-sponsored = { $provider } ∙ ਸਪਾਂਸਰ
newtab-weather-menu-change-location = ਟਿਕਾਣੇ ਨੂੰ ਬਦਲੋ
newtab-weather-change-location-search-input-placeholder =
    .placeholder = ਟਿਕਾਣੇ ਨੂੰ ਖੋਜੋ
    .aria-label = ਟਿਕਾਣੇ ਨੂੰ ਖੋਜੋ
newtab-weather-menu-weather-display = ਮੌਸਮ ਦੀ ਝਲਕ
# Display options are:
# - Simple: Displays a current weather condition icon and the current temperature
# - Detailed: Include simple information plus a short text summary: e.g. "Mostly cloudy"
newtab-weather-menu-weather-display-option-simple = ਸਧਾਰਨ
newtab-weather-menu-change-weather-display-simple = ਸਰਲ ਝਲਕ ਲਈ ਬਦਲੋ
newtab-weather-menu-weather-display-option-detailed = ਵੇਰਵੇ ਸਮੇਤ
newtab-weather-menu-change-weather-display-detailed = ਵੇਰਵੇ ਸਮੇਤ ਝਲਕ ਲਈ ਬਦਲੋ
newtab-weather-menu-temperature-units = ਤਾਪਮਾਨ ਦੀ ਇਕਾਈ
newtab-weather-menu-temperature-option-fahrenheit = ਫਾਹਰਨਹੀਟ
newtab-weather-menu-temperature-option-celsius = ਸੈਲਸੀਅਸ
newtab-weather-menu-change-temperature-units-fahrenheit = ਫਾਹਰਨਹੀਟ ਵਿੱਚ ਬਦਲੋ
newtab-weather-menu-change-temperature-units-celsius = ਸੈਲਸੀਅ ਵਿੱਚ ਬਦਲੋ
newtab-weather-menu-hide-weather = ਨਵੀਂ ਟੈਬ ਉੱਤੇ ਮੌਸਮ ਨੂੰ ਲੁਕਾਓ
newtab-weather-menu-learn-more = ਹੋਰ ਜਾਣੋ
newtab-weather-menu-detect-my-location = ਮੇਰੇ ਟਿਕਾਣੇ ਨੂੰ ਖੋਜੋ
# This message is shown if user is working offline
newtab-weather-error-not-available = ਮੌਸਮ ਦਾ ਡਾਟਾ ਹਾਲੇ ਮੌਜੂਦ ਨਹੀਂ ਹੈ।
newtab-weather-opt-in-see-weather = ਕੀ ਤੁਸੀਂ ਆਪਣੇ ਟਿਕਾਣੇ ਲਈ ਮੌਸਮ ਵੇਖਣਾ ਚਾਹੋਗੇ?
newtab-weather-opt-in-not-now =
    .label = ਹੁਣੇ ਨਹੀਂ
newtab-weather-opt-in-yes =
    .label = ਹਾਂ
# We'll be showing static (fake) weather data if the user has not opted in to using their location
newtab-weather-static-city = ਅੰਮ੍ਰਿਤਸਰ

## Topic Labels

newtab-topic-label-business = ਵਪਾਰਕ
newtab-topic-label-career = ਕੈਰੀਅਰ
newtab-topic-label-education = ਸਿੱਖਿਆ
newtab-topic-label-arts = ਮਨੋਰੰਜਨ
newtab-topic-label-food = ਖਾਣ-ਪੀਣ
newtab-topic-label-health = ਸਿਹਤ
newtab-topic-label-hobbies = ਗੇਮਾਂ
# ”Money” = “Personal Finance”, refers to articles and stories that help readers better manage
# and understand their personal finances – from saving money to buying a home. See the
# “Curated by our editors“ section at the top of https://getpocket.com/explore/personal-finance for more context
newtab-topic-label-finance = ਪੈਸਾ
newtab-topic-label-society-parenting = ਮਾਪੇ
newtab-topic-label-government = ਰਾਜਨੀਤੀ
newtab-topic-label-education-science = ਵਿਗਿਆਨ
# ”Life Hacks” = “Self Improvement”, refers to articles and stories aimed at helping readers improve various
# aspects of their lives – from mental health to  productivity. See the “Curated by our editors“ section
# at the top of https://getpocket.com/explore/self-improvement for more context.
newtab-topic-label-society = ਜ਼ਿੰਦਗੀ ਦੇ ਟੋਟਕੇ
newtab-topic-label-sports = ਖੇਡਾਂ
newtab-topic-label-tech = ਤਕਨੀਕੀ
newtab-topic-label-travel = ਯਾਤਰਾ
newtab-topic-label-home = ਘਰ ਤੇ ਬਗੀਚੀ

## Topic Selection Modal

# “fine-tune” refers to the process of making small adjustments to something to get
# the best or desired experience or performance.
newtab-topic-selection-title = ਆਪਣੀ ਫ਼ੀਡ ਨੂੰ ਮੁਆਫ਼ਕ ਬਣਾਉਣ ਲਈ ਵਿਸ਼ਿਆਂ ਨੂੰ ਚੁਣੋ
# “tailored” refers to process of (a tailor) making (clothes) to fit individual customers.
# In other words, “Our expert curators prioritize stories to fit your selected interests”
newtab-topic-selection-subtitle = ਦੋ ਜਾਂ ਵੱਧ ਵਿਸ਼ਿਆਂ ਨੂੰ ਚੁਣੋ। ਸਾਡੇ ਮਾਹਰ ਨਿਗਰਾਨ ਤੁਹਾਡੀਆਂ ਦਿਲਚਪੀਆਂ ਮੁਤਾਬਕ ਕਹਾਣੀਆਂ ਨੂੰ ਤਰਜੀਹ ਦਿੰਦੇ ਹਨ। ਕਿਸੇ ਵੀ ਵੇਲੇ ਅੱਪਡੇਟ ਕਰੋ।
newtab-topic-selection-save-button = ਸੰਭਾਲੋ
newtab-topic-selection-cancel-button = ਰੱਦ ਕਰੋ
newtab-topic-selection-button-maybe-later = ਫੇਰ ਕਦੇ
newtab-topic-selection-privacy-link = ਜਾਣੋ ਕਿ ਅਸੀਂ ਡਾਟੇ ਨੂੰ ਕਿਵੇਂ ਸੁਰੱਖਿਅਤ ਰੱਖਦੇ ਅਤੇ ਇਸ ਦਾ ਇੰਤਜ਼ਾਮ ਕਰਦੇ ਹਾਂ
newtab-topic-selection-button-update-interests = ਆਪਣੀਆਂ ਦਿਲਚਸਪੀਆਂ ਨੂੰ ਅੱਪਡੇਟ ਕਰੋ
newtab-topic-selection-button-pick-interests = ਆਪਣੀਆਂ ਦਿਲਚਸਪੀਆਂ ਨੂੰ ਚੁਣੋ

## Content Feed Sections
## "Follow", "unfollow", and "following" are social media terms that refer to subscribing to or unsubscribing from a section of stories.
## e.g. Following the travel section of stories.

newtab-section-follow-button = ਫ਼ਾਲੋ ਕਰੋ
newtab-section-following-button = ਫ਼ਾਲੋ ਕੀਤਾ ਜਾ ਰਿਹਾ ਹੈ
newtab-section-unfollow-button = ਅਣ-ਫ਼ਾਲੋ ਕਰੋ
# A modal may appear next to the Follow button, directing users to try out the feature
newtab-section-follow-highlight-title = ਆਪਣੀ ਫੀਡ ਨੂੰ ਸੈੱਟ ਕਰੋ
newtab-section-follow-highlight-subtitle = ਆਪਣੀਆਂ ਦਿਲਚਸਪੀਆਂ ਨੂੰ ਵੇਖਣ ਲਈ ਉਹਨਾਂ ਨੂੰ ਫ਼ਾਲੋ ਕਰੋ।

## Button to block/unblock listed topics
## "Block", "unblocked", and "blocked" are social media terms that refer to hiding a section of stories.
## e.g. Blocked the politics section of stories.

newtab-section-block-button = ਪਾਬੰਦੀ ਲਾਓ
newtab-section-blocked-button = ਪਾਬੰਦੀ ਲਗਾਈ
newtab-section-unblock-button = ਪਾਬੰਦੀ ਹਟਾਓ

## Confirmation modal for blocking a section

newtab-section-cancel-button = ਹੁਣੇ ਨਹੀਂ
newtab-section-confirm-block-topic-p1 = ਕੀ ਤੁਸੀਂ ਇਸ ਵਿਸ਼ੇ ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?
newtab-section-confirm-block-topic-p2 = ਪਾਬੰਦੀ ਲਾਏ ਵਿਸ਼ੇ ਤੁਹਾਡੀ ਫੀਡ ਵਿੱਚ ਦਿਖਾਈ ਨਹੀਂ ਦੇਣਗੇ।
# Variables:
#   $topic (string) - Name of topic that user is blocking
newtab-section-block-topic-button = { $topic } ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਓ

## Strings for custom wallpaper highlight

newtab-section-mangage-topics-title = ਵਿਸ਼ੇ:
newtab-section-manage-topics-button-v2 =
    .label = ਵਿਸ਼ਿਆਂ ਦਾ ਇੰਤਜ਼ਾਮ
newtab-section-mangage-topics-followed-topics = ਫ਼ਾਲੋ ਕੀਤੇ
newtab-section-mangage-topics-followed-topics-empty-state = ਤੁਸੀਂ ਹਾਲੇ ਕਿਸੇ ਵੀ ਵਿਸ਼ੇ ਨੂੰ ਫ਼ਾਲੋ ਨਹੀਂ ਕੀਤਾ ਹੈ।
newtab-section-mangage-topics-blocked-topics = ਪਾਬੰਦੀ ਲਗਾਏ
newtab-section-mangage-topics-blocked-topics-empty-state = ਤੁਸੀਂ ਹਾਲੇ ਕਿਸੇ ਵੀ ਵਿਸ਼ੇ ਉੱਤੇ ਪਾਬੰਦੀ ਨਹੀਂ ਲਾਈ ਹੈ।
newtab-custom-wallpaper-title = ਪਸੰਦੀਦਾ ਵਾਲਪੇਪਰ ਇੱਥੇ ਹਨ
# 'Make firefox yours" means to customize or personalize
newtab-custom-wallpaper-subtitle = { -brand-product-name } ਨੂੰ ਆਪਣਾ ਬਣਾਉਣ ਵਾਸਤੇ ਖੁਦ ਦਾ ਵਾਲਪੇਪਰ ਅੱਪਲੋਡ ਕਰੋ ਜਾਂ ਕਸਟਮ ਰੰਗ ਚੁਣੋ।
newtab-custom-wallpaper-cta = ਅਜ਼ਮਾਓ

## Strings for new user activation custom wallpaper highlight

newtab-new-user-custom-wallpaper-title = { -brand-product-name } ਨੂੰ ਆਪਣੀ ਪਸੰਦ ਦਾ ਬਣਾਉਣ ਵਾਸਤੇ ਕੋਈ ਵਾਲਪੇਪਰ ਚੁਣੋ।
newtab-new-user-custom-wallpaper-subtitle = ਪਸੰਦੀਦਾ ਵਾਲਪੇਪਰਾਂ ਅਤੇ ਰੰਗਾਂ ਨਾਲ ਹਰ ਨਵੀਂ ਟੈਬ ਨੂੰ ਆਪਣੇ ਮੁਤਾਬਕ ਢਾਲੋ।
newtab-new-user-custom-wallpaper-cta = ਹੁਣੇ ਅਜ਼ਮਾਓ

## Strings for download mobile highlight

newtab-download-mobile-highlight-title = ਮੋਬਾਈਲ ਲਈ { -brand-product-name } ਨੂੰ ਡਾਊਨਲੋਡ ਕਰੋ
# "Scan the code" refers to scanning the QR code that appears above the body text that leads to Firefox for mobile download.
newtab-download-mobile-highlight-body-variant-a = ਰਾਹ ਵਿੱਚ ਸੁਰੱਖਿਅਤ ਢੰਗ ਨਾਲ ਬਰਾਊਜ਼ ਕਰਨ ਵਾਸਤੇ ਕੋਡ ਨੂੰ ਸਕੈਨ ਕਰੋ।
newtab-download-mobile-highlight-body-variant-b = ਜਦੋਂ ਤੁਸੀਂ ਆਪਣੀਆਂ ਟੈਬਾਂ, ਪਾਸਵਰਡਾਂ ਅਤੇ ਹੋਰ ਚੀਜ਼ਾਂ ਨੂੰ ਸਿੰਕ ਕਰਦੇ ਹੋ ਤਾਂ ਜਿੱਥੇ ਛੱਡਿਆ, ਉਥੋਂ ਹੀ ਵਰਤਣਾ ਜਾਰੀ ਰੱਖ ਸਕਦੇ ਹੋ।
newtab-download-mobile-highlight-body-variant-c = ਕੀ ਤੁਹਾਨੂੰ ਪਤਾ ਸੀ ਕਿ ਤੁਸੀਂ ਰਾਹ ਵਿੱਚ { -brand-product-name } ਨੂੰ ਵਰਤ ਸਕਦੇ ਹੋ? ਉਹੀ ਬਰਾਊਜ਼ਰ। ਤੁਹਾਡੀ ਜੇਬ ਵਿੱਚ।
newtab-download-mobile-highlight-image =
    .aria-label = ਮੋਬਾਈਲ ਵਾਸਤੇ { -brand-product-name } ਡਾਊਨਲੋਡ ਕਰਨ ਲਈ QR ਕੋਡ

## Strings for shortcuts highlight

newtab-shortcuts-highlight-title = ਤੁਹਾਡੇ ਮਨਪਸੰਦ ਤੁਹਾਡੀਆਂ ਉਂਗਲਾਂ ਉੱਤੇ
newtab-shortcuts-highlight-subtitle = ਆਪਣੀਆਂ ਮਨਪਸੰਦ ਸਾਈਟਾਂ ਨੂੰ ਕਲਿੱਕ ਨਾਲ ਖੋਲ੍ਹਣ ਲਈ ਸ਼ਾਰਟਕੱਟ ਵਿੱਚ ਜੋੜੋ।

## Strings for reporting ads and content

newtab-report-content-why-reporting-this =
    .label = ਤੁਸੀਂ ਇਸ ਬਾਰੇ ਰਿਪੋਰਟ ਕਿਉਂ ਕਰ ਰਹੇ ਹੋ?
newtab-report-ads-reason-not-interested =
    .label = ਮੇਰੀ ਦਿਲਚਸਪੀ ਨਹੀਂ ਹੈ
newtab-report-ads-reason-inappropriate =
    .label = ਇਹ ਬੇਤੁਕਾ ਹੈ
newtab-report-ads-reason-seen-it-too-many-times =
    .label = ਮੈਂ ਇਸ ਨੂੰ ਬਹੁਤ ਵਾਰ ਦੇਖਿਆ
newtab-report-content-wrong-category =
    .label = ਗਲਤ ਵਰਗ
newtab-report-content-outdated =
    .label = ਪੁਰਾਣਾ
newtab-report-content-inappropriate-offensive =
    .label = ਬੇਤੁਕੀ ਜਾਂ ਅਪਮਾਨਜਨਕ
newtab-report-content-spam-misleading =
    .label = ਸਪੈਮ ਜਾਂ ਗੁੰਮਰਾਹਕੁੰਨ
newtab-report-cancel = ਰੱਦ ਕਰੋ
newtab-report-submit = ਭੇਜੋ
newtab-toast-thanks-for-reporting =
    .message = ਇਸ ਬਾਰੇ ਜਾਣਕਾਰੀ ਦੇਣ ਲਈ ਤੁਹਾਡਾ ਧੰਨਵਾਦ!

## Strings for trending searches

newtab-trending-searches-show-trending =
    .title = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ ਨੂੰ ਵੇਖਾਓ
newtab-trending-searches-hide-trending =
    .title = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ ਨੂੰ ਲੁਕਾਓ
newtab-trending-searches-learn-more = ਹੋਰ ਜਾਣੋ
newtab-trending-searches-dismiss = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ ਨੂੰ ਲੁਕਾਓ
# "Trending searches refers to popular searches from search engines
newtab-trending-searches-title = ਰੁਝਾਨ ਵਿੱਚ ਖੋਜਾਂ

## Strings for task / to-do list productivity widget

# "Add one" means adding a new task to the list (e.g., "Walk the dog")
newtab-widget-lists-empty-cta = ਸੰਭਾਵਨਾਵਾਂ ਤਾਂ ਬੇਸ਼ੁਮਾਰ ਹਨ। ਇੱਕ ਜੋੜੋ।
# A simple label next to the default list name letting users know this is a new / beta feature
newtab-widget-lists-label-new =
    .label = ਨਵਾਂ
newtab-widget-lists-label-beta =
    .label = ਬੀਟਾ
# When tasks have been previous marked as complete, they will appear in their own separate list beneath incomplete items
# Variables:
#   $number (number) - Amount of list items marked complete
newtab-widget-lists-completed-list = ਪੂਰੇ ਹੋਏ ({ $number })
newtab-widget-task-list-menu-copy = ਕਾਪੀ ਕਰੋ
newtab-widget-lists-menu-edit = ਸੂਚੀ ਦੇ ਨਾਂ ਨੂੰ ਸੋਧੋ
newtab-widget-lists-menu-create = ਇੱਕ ਨਵੀਂ ਲਿਸਟ ਬਣਾਓ
newtab-widget-lists-menu-delete = ਇਸ ਸੂਚੀ ਨੂੰ ਹਟਾਓ
newtab-widget-lists-menu-copy = ਸੂਚੀ ਨੂੰ ਕਲਿੱਪਬੋਰਡ ਵਿੱਚ ਕਾਪੀ ਕਰੋ
newtab-widget-lists-menu-hide = ਸਭ ਸੂਚੀਆਂ ਨੂੰ ਓਹਲੇ ਕਰੋ
newtab-widget-lists-menu-learn-more = ਹੋਰ ਜਾਣੋ
newtab-widget-lists-input-add-an-item =
    .placeholder = ਇੱਕ ਚੀਜ਼ ਨੂੰ ਜੋੜੋ
newtab-widget-lists-input-error = ਇੱਕ ਚੀਜ਼ ਨੂੰ ਜੋੜਨ ਲਈ ਲਿਖਤ ਨੂੰ ਸ਼ਾਮਲ ਕਰੋ।
newtab-widget-lists-input-menu-open-link = ਲਿੰਕ ਨੂੰ ਖੋਲ੍ਹੋ
newtab-widget-lists-input-menu-move-up = ਉੱਤੇ ਭੇਜੋ
newtab-widget-lists-input-menu-move-down = ਹੇਠਾਂ ਭੇਜੋ
newtab-widget-lists-input-menu-delete = ਹਟਾਓ
newtab-widget-lists-input-menu-edit = ਸੋਧੋ
# the + symbol emphasises the functionality of adding a new list
newtab-widget-lists-dropdown-create =
    .label = + ਨਵੀਂ ਸੂਚੀ ਬਣਾਓ
newtab-widget-lists-name-label-default =
    .label = ਕੰਮ ਸੂਚੀ
newtab-widget-lists-name-placeholder-default =
    .placeholder = ਕੰਮ ਸੂਚੀ
# The placeholder value of the name field for a newly created list
newtab-widget-lists-name-placeholder-new =
    .placeholder = ਨਵੀਂ ਸੂਚੀ

## Strings for timer productivity widget
## When the timer ends, a system notification may be shown. Depending on which mode the timer is in, that message would be shown

newtab-widget-timer-notification-title = ਟਾਈਮਰ
newtab-widget-timer-notification-focus = ਫੋਕਸ ਸਮਾਂ ਸਮਾਪਤ ਹੋਇਆ। ਵਧੀਆ ਕੰਮ ਕੀਤਾ, ਸਾਹ ਲੈਣਾ ਹੈ?
newtab-widget-timer-notification-break = ਤੁਹਾਡੀ ਬਰੇਕ ਖ਼ਤਮ ਹੋਈ। ਫੋਕਸ ਕਰਨ ਲਈ ਤਿਆਰ ਹੋ?
newtab-widget-timer-notification-warning = ਨੋਟੀਫਿਕੇਸ਼ਨ ਬੰਦ ਹਨ
newtab-widget-timer-mode-focus =
    .label = ਫੋਕਸ
newtab-widget-timer-mode-break =
    .label = ਬਰੇਕ
newtab-widget-timer-label-play =
    .label = ਖੇਡਣ
newtab-widget-timer-label-pause =
    .label = ਵਿਰਾਮ
newtab-widget-timer-reset =
    .title = ਮੁੜ-ਸੈੱਟ
newtab-widget-timer-menu-notifications = ਨੋਟੀਫਿਕੇਸ਼ਨਾਂ ਨੂੰ ਚਾਲੂ ਕਰੋ
newtab-widget-timer-menu-notifications-on = ਨੋਟੀਫਿਕੇਸ਼ਨਾਂ ਨੂੰ ਚਾਲੂ ਕਰੋ
newtab-widget-timer-menu-hide = ਟਾਈਮਰ ਓਹਲੇ ਕਰੋ
newtab-widget-timer-menu-learn-more = ਹੋਰ ਜਾਣੋ
# Message that appears when widgets are full-height. This reminds users that there is more New Tab content to see if they scroll
newtab-widget-keep-scrolling = ਹੋਰ ਲਈ ਸਕਰੋਲ ਕਰੋ
newtab-widget-message-title = ਸੂਚੀਆਂ ਅਤੇ ਵਿੱਚ ਮੌਜੂਦ ਟਾਈਮਰ ਨਾਲ ਫੋਕਸ ਰਹੋ
# to-dos stands for "things to do".
newtab-widget-message-copy = ਕਰਨ ਵਾਲੇ ਕੰਮਾਂ, ਫ਼ੋਕਸ ਵਾਲੇ ਸ਼ੈਸ਼ਨਾਂ ਤੋਂ ਲੈ ਕੇ ਛੋਟੀ ਬਰੇਕ ਲੈਣ ਲਈ ਫ਼ੌਰਨ ਯਾਦ ਕਰਵਾਉਣਾ — ਕੰਮ ਸਮੇਂ ਸਿਰ ਪੂਰੇ ਕਰੋ।
newtab-promo-card-title = { -brand-product-name } ਲਈ ਸਹਿਯੋਗ
newtab-promo-card-body = ਸਾਡੇ ਸਪੌਂਸ ਵਧੀਆ ਵੈੱਬ ਬਣਾਉਣ ਦੇ ਸਾਡੇ ਟੀਚੇ ਵਿੱਚ ਸਹਿਯੋਗ ਕਰਦੇ ਹਨ।
newtab-promo-card-cta = ਹੋਰ ਜਾਣੋ
newtab-promo-card-dismiss-button =
    .title = ਖ਼ਾਰਜ ਕਰੋ
    .aria-label = ਖ਼ਾਰਜ ਕਰੋ
